<?php session_start();
require_once 'config.php'; ?><!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Contact Us - Cleaning Service</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link
        href="../../css2-2?family=Fuzzy+Bubbles:wght@400;700&family=Poppins:wght@400;500;600;700;800&family=Rubik:ital,wght@0,300..900;1,300..900&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/slick.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>

<body>
    <!-- <div class="preloader"><button class="vs-btn preloaderCls">Cancel Preloader</button>
        <div class="preloader-inner"><img src="assets/img/logo.svg" alt="logo"><span class="loader"></span></div>
    </div> -->
    <?php include 'header.php'; ?>
    <div class="breadcumb-wrapper " data-bg-src="assets/img/breadcumb/breadcumb-bg.png">
        <div class="container z-index-common">
            <div class="breadcumb-content">
                <h1 class="breadcumb-title">contact Us <span>us</span></h1>
            </div>
            <div class="breadcumb-menu-wrap">
                <ul class="breadcumb-menu">
                    <li><a href="index.php">Contact</a></li>
                    <li>contact us</li>
                </ul>
            </div>
        </div>
    </div>
     <section class="contact-layout1 space" style="padding-bottom:0px">
    <div class="container">
        <div class="row g-5 gx-60 align-items-center">

            <!-- Contact Info -->
            <div class="col-xl-5 col-lg-5 col-md-12">
                <div class="contact-style1">
                    <div class="title-area text-left">
                        <span class="sec-subtitle">CONTACT US</span>
                        <h2 class="sec-title">Get in Touch With Us</h2>
                    </div>

                    <div class="contact-inner">
                        <?php
                        // Fetch contact settings from database
                        $address_query = "SELECT setting_value FROM settings WHERE setting_key = 'company_address'";
                        $phone_query = "SELECT setting_value FROM settings WHERE setting_key = 'company_phone'";
                        $email_query = "SELECT setting_value FROM settings WHERE setting_key = 'company_email'";

                        $address_result = $conn->query($address_query);
                        $phone_result = $conn->query($phone_query);
                        $email_result = $conn->query($email_query);

                        $address = ($address_result && $address_result->num_rows > 0) ? $address_result->fetch_assoc()['setting_value'] : 'Roda WQ 966, Munich Express 70, Germany – Park Lane, TX 7859';
                        $phone = ($phone_result && $phone_result->num_rows > 0) ? $phone_result->fetch_assoc()['setting_value'] : '+9-555-888-679, +9-666-888-679';
                        $email = ($email_result && $email_result->num_rows > 0) ? $email_result->fetch_assoc()['setting_value'] : 'example@info.com';
                        ?>
                        
                        <div class="contact-address">
                            <span>Address</span>
                            <p class="address">
                                <?php echo htmlspecialchars($address); ?>
                            </p>
                        </div>

                        <div class="contact-box">
                            <span class="contact-icon">
                                <i class="fa-light fa-phone-volume"></i>
                            </span>
                            <div class="contact-content">
                                <h6 class="contact-title">Customer Support</h6>
                                <p class="contact-text"><?php echo htmlspecialchars($phone); ?></p>
                            </div>
                        </div>

                        <div class="contact-box">
                            <span class="contact-icon">
                                <i class="fa-regular fa-envelope"></i>
                            </span>
                            <div class="contact-content">
                                <h6 class="contact-title">Email</h6>
                                <p class="contact-text"><?php echo htmlspecialchars($email); ?></p>
                            </div>
                        </div>
                    </div>

                    <div class="social-style2">
                        <span class="social-title">Follow Us</span>
                        <div class="social-icon">
                            <a href="#"><i class="fa-brands fa-x-twitter"></i></a>
                            <a href="#"><i class="fab fa-linkedin-in"></i></a>
                            <a href="#"><i class="fab fa-instagram"></i></a>
                            <a href="#"><i class="fa-brands fa-vimeo-v"></i></a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Contact Form -->
            <div class="col-xl-7 col-lg-7 col-md-12">
                <div class="form-style2">
                    <?php
                    // Check if user is logged in
                    $is_logged_in = isset($_SESSION['user_id']);
                    
                    // Handle form submission
                    $form_message = '';
                    $form_message_type = '';

                    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                        // Check if user is logged in before processing
                        if (!$is_logged_in) {
                            $form_message = 'Please log in to send a message. You will be redirected to login page.';
                            $form_message_type = 'error';
                        } else {
                            // Get form data
                            $name = isset($_POST['name']) ? trim($_POST['name']) : '';
                            $email_input = isset($_POST['email']) ? trim($_POST['email']) : '';
                            $phone_input = isset($_POST['phone']) ? trim($_POST['phone']) : '';
                            $subject = isset($_POST['subject']) ? trim($_POST['subject']) : '';
                            $message_input = isset($_POST['message']) ? trim($_POST['message']) : '';

                            // Validation
                            if (empty($name) || empty($email_input) || empty($phone_input) || empty($message_input)) {
                                $form_message = 'All fields are required.';
                                $form_message_type = 'error';
                            } elseif (!filter_var($email_input, FILTER_VALIDATE_EMAIL)) {
                                $form_message = 'Please enter a valid email address.';
                                $form_message_type = 'error';
                            } else {
                                // Insert into database
                                $insert_query = "INSERT INTO contact_messages (name, email, phone, subject, message, status) VALUES (?, ?, ?, ?, ?, 'new')";
                                $stmt = $conn->prepare($insert_query);

                                if ($stmt) {
                                    $stmt->bind_param('sssss', $name, $email_input, $phone_input, $subject, $message_input);
                                    
                                    if ($stmt->execute()) {
                                        $form_message = 'Thank you! Your message has been sent successfully. We will get back to you soon.';
                                        $form_message_type = 'success';
                                        // Clear form data
                                        $name = $email_input = $phone_input = $subject = $message_input = '';
                                    } else {
                                        $form_message = 'Error sending message. Please try again.';
                                        $form_message_type = 'error';
                                    }
                                    $stmt->close();
                                }
                            }
                        }
                    }

                    // Get values for form re-population
                    $name = isset($_POST['name']) ? htmlspecialchars($_POST['name']) : '';
                    $email_input = isset($_POST['email']) ? htmlspecialchars($_POST['email']) : '';
                    $phone_input = isset($_POST['phone']) ? htmlspecialchars($_POST['phone']) : '';
                    $subject = isset($_POST['subject']) ? htmlspecialchars($_POST['subject']) : '';
                    $message_input = isset($_POST['message']) ? htmlspecialchars($_POST['message']) : '';
                    ?>

                    <?php if (!$is_logged_in): ?>
                        <div style="padding: 20px; margin-bottom: 20px; border-radius: 8px; background: #fff3cd; color: #856404; border: 1px solid #ffeeba; text-align: center;">
                            <h5 style="margin-bottom: 12px;"><i class="fa-solid fa-lock"></i> Login Required</h5>
                            <p style="margin-bottom: 15px;">You must be logged in to send us a message.</p>
                            <a href="login.php" class="vs-btn">
                                <i class="fa-solid fa-sign-in-alt"></i> Login Now
                            </a>
                            <p style="margin-top: 12px; font-size: 14px;">Don't have an account? 
                                <a href="register.php" style="color: #0066cc; text-decoration: none; font-weight: 600;">Register here</a>
                            </p>
                        </div>
                    <?php endif; ?>

                    <?php if ($form_message): ?>
                        <div style="padding: 15px; margin-bottom: 20px; border-radius: 8px; <?php echo $form_message_type === 'success' ? 'background: #d4edda; color: #155724; border: 1px solid #c3e6cb;' : 'background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;'; ?>">
                            <?php echo $form_message; ?>
                        </div>
                    <?php endif; ?>

                    <form method="POST" action="" <?php echo !$is_logged_in ? 'style="opacity: 0.5; pointer-events: none;"' : ''; ?>>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <input type="text" name="name" class="form-control" placeholder="First Name *" value="<?php echo $name; ?>" <?php echo !$is_logged_in ? 'disabled' : ''; ?> required>
                            </div>
                            <div class="col-md-6">
                                <input type="email" name="email" class="form-control" placeholder="Email Address *" value="<?php echo $email_input; ?>" <?php echo !$is_logged_in ? 'disabled' : ''; ?> required>
                            </div>
                            <div class="col-md-6">
                                <input type="tel" name="phone" class="form-control" placeholder="Phone Number *" value="<?php echo $phone_input; ?>" <?php echo !$is_logged_in ? 'disabled' : ''; ?> required>
                            </div>
                            <div class="col-md-6">
                                <input type="text" name="subject" class="form-control" placeholder="Subject (Optional)" value="<?php echo $subject; ?>" <?php echo !$is_logged_in ? 'disabled' : ''; ?>>
                            </div>
                            <div class="col-12">
                                <textarea class="form-control" name="message" rows="5" placeholder="Your Message *" <?php echo !$is_logged_in ? 'disabled' : ''; ?> required><?php echo $message_input; ?></textarea>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="vs-btn w-100" <?php echo !$is_logged_in ? 'disabled' : ''; ?>>Send Message</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
    <style>
        /* =========================
   CONTACT SECTION
========================= */

.contact-style1 {
    background: #fff;
    padding: 35px;
    border-radius: 16px;
    box-shadow: 0 10px 35px rgba(0,0,0,0.08);
}

.contact-inner {
    margin-top: 25px;
}

.contact-address span {
    font-weight: 600;
    display: block;
    margin-bottom: 5px;
}

.contact-address p {
    font-size: 14px;
    color: #555;
    line-height: 1.6;
}

.contact-box {
    display: flex;
    gap: 15px;
    margin-top: 20px;
}

.contact-icon {
    width: 42px;
    height: 42px;
    background: #1e88e5;
    color: #fff;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
}

.contact-title {
    font-size: 15px;
    margin-bottom: 4px;
}

.contact-text {
    font-size: 14px;
    color: #555;
}

/* Social */
.social-style2 {
    margin-top: 30px;
}

.social-icon a {
    display: inline-flex;
    width: 38px;
    height: 38px;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    background: #f1f1f1;
    margin-right: 8px;
    color: #333;
    transition: 0.3s;
}

.social-icon a:hover {
    background: #1e88e5;
    color: #fff;
}

/* Form */
.form-style2 {
    background: #fff;
    padding: 40px;
    border-radius: 16px;
    box-shadow: 0 10px 35px rgba(0,0,0,0.08);
}

.form-control {
    height: 48px;
    border-radius: 8px;
    font-size: 14px;
}

textarea.form-control {
    height: auto;
}

/* Tablet */
@media (max-width: 991px) {
    .contact-style1,
    .form-style2 {
        padding: 30px;
    }
}

/* Mobile */
@media (max-width: 576px) {
    .contact-style1,
    .form-style2 {
        padding: 25px 20px;
    }

    .contact-box {
        flex-direction: column;
    }

    .social-icon a {
        margin-bottom: 6px;
    }
}

    </style>
</section>

    <!--==============================
    map Area
    ==============================-->
    <div class="map-layout1">
        <style>
            /* =========================
   MAP RESPONSIVE LAYOUT
========================= */

.map-layout1 {
    margin-bottom: 20px;
    width: 100%;
    margin-top: 60px;
}

.map-responsive {
    position: relative;
    width: 100%;
    height: 550px;
    border-radius: 18px;
    overflow: hidden;
    box-shadow: 0 12px 40px rgba(0,0,0,0.15);
}

.map-responsive iframe {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    border: 0;
}

/* Tablet */
@media (max-width: 991px) {
    .map-responsive {
        height: 420px;
    }
}

/* Mobile */
@media (max-width: 576px) {
    .map-responsive {
        height: 300px;
        border-radius: 14px;
    }
}

        </style>
    <div class="map-responsive">
        <iframe 
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d163720.11965853968!2d8.496481908353967!3d50.121347879150306!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47bd096f477096c5%3A0x422435029b0c600!2sFrankfurt%2C%20Germany!5e0!3m2!1sen!2sbd!4v1665403058628!5m2!1sen!2sbd"
            allowfullscreen
            loading="lazy"
            referrerpolicy="no-referrer-when-downgrade">
        </iframe>
    </div>
</div>
    <?php include 'footer.php'; ?>
    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/gsap-scroll-to-plugin.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/main.js"></script>
</body>

</html>